;This program is used in the ARRL's Big Project Activity Board to control the digital 
;potentiometer used in the variable frequency oscillator.  Not only does this program
;control the pot, but it also provides clock, data, and chip select signals that the
;teacher can use to demonstrate serial communications techniques.  Program written by
;Mark Spencer, WA8SME, Project Coordinator.  Phone 860-594-0396 or e-mail
;mspencer@arrl.org.


	list      p=12F675       ; list directive to define processor
	#include <p12f675.inc>    ; processor specific variable definitions

	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN_ON & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define I_OTris		B'00000011'		;GPIO pins 0, 1, and 2 are outputs, 4 and 5 inputs
#define Set_ANSEL	b'00010011'		;pins 0,1 input, 8Tosc
#define Set_ADCON0	b'10000001'		;right justified, Vcc as VRef, cho, A/D on
#define Set_OptReg	b'10000000'		;pullups disabled
#define	counter 	0x08			;set number of counts to 8
#define	rts			0x02			;GPIO pin 2 is chip select pin RTS
#define	clk			0x04			;GPIO pin 4 is clock
#define	dline		0x05			;GPIO pin 5 is data
#define	resist_up	0x04			;GPIO pin 3 switch closed for up
#define	resist_down	0x05			;GPIO pin 4 switch closed for down


;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	stackselect						;used to hold stack slect bit, 0=wiper 0, 1=wiper 1
	txdataHI						;used to send HI 8 bits of data to resistor
	txdataLO						;used to send LO 8 bits of data to resistor
	txdata							;used for temp holding of data
	sendreg							;space to place byte to be transmitted out
;	data_out						;space for resistor position number to be transmitted
	bit_count						;used for bit counter loops
	countH							; debounce counter - MS Byte
	countL							; debounce counter - LS Byte
	ACCaLO
	ACCaHI
	ACCbLO
	ACCbHI
	endc

;******************************************************************************
;Reset Vector 
;******************************************************************************

	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************

	ORG	0x004
	;goto interupt_service
	return					; interrupt trap - returns without re-enabling

;******************************************************************************
;Initialization
;******************************************************************************
Init
	
	;call    0x3FF     		; retrieve factory calibration value
							; comment instruction if using simulator, ICD2, or ICE2000
	BANKSEL	Bank1			; BANK1
	movwf   OSCCAL      	; update register with factory cal value 
	movlw	I_OTris			; set direction of ports
	movwf	TRISIO			;
	movlw	Set_ANSEL 
	movwf	ANSEL			; configure A/D I/O as digital
	bsf		OPTION_REG,7	; disenable weak pull ups
	BANKSEL	Bank0			; change back to PORT memory bank
	clrf	INTCON			; Disable all interups
	clrf	GPIO			; Set all ports to zero
	movlw	Set_ADCON0
	movwf	ADCON0			; set right justified, Vref, ch0, and A/D on
	clrf	CMCON			;
	
	

;******************************************************************************
;Main 
;******************************************************************************
Main
	clrf	txdataLO
	clrf	txdataHI
	clrf	txdata	
;	movlw	.3
;	movwf	ADRESH
;	BANKSEL	Bank1
;	movlw	.240
;	movwf	ADRESL
;	BANKSEL	Bank0
	bsf		ADCON0,1		;start ADC conversion
wait_for_conversion
	btfsc	ADCON0,1		;check if conversion done, zero = complete
	goto 	wait_for_conversion
	bcf		STATUS,C		;clear carry bit for use
	rrf		ADRESH,f		;rotate high byte right one and use carry
	movfw	ADRESH
	movwf	txdataHI		;place in tx high byte
	BANKSEL	Bank1			;change banks to access ADRESL
	rrf		ADRESL,f		;rotate low byte right one include carry from ADRESH
	movfw	ADRESL
	movwf	txdataLO		;place in tx low byte
	BANKSEL	Bank0

	btfss	txdataHI,0		;check if ADC>255
	goto	wiper_low
wiper_high					;if ADC>255 put low byte into
	movfw	txdataLO		;high byte and select wiper1
	movwf	txdataHI
	bsf		stackselect,0
	goto	data_out

wiper_low
	bcf		stackselect,0	;if ADC<256 send low byte
							;and select wiper0
data_out
	call	send_data
	goto	Main	


;lowbyte

;	incfsz	txdataLO,f		;skip if zero
;	goto 	continueLO
;	goto	highbyte
;continueLO
;	bcf		stackselect,0
;	movfw	txdataLO
;	movwf	txdata
;	call	send_data
;	movfw	txdata
;	movwf	txdataLO
;	goto 	lowbyte


;highbyte
	
;	incfsz	txdataHI,f
;	goto	continueHI
;	goto	Main
;continueHI	
;	bsf	stackselect,0
;	movfw	txdataHI
;	movwf	txdata
;	call send_data	
;	movfw	txdata
;	movwf	txdataHI	
;	goto	highbyte

;******************************************************************************
;Subroutines & Functions
;******************************************************************************

					;from send_stackselect

send_data
send_stackselect
	bcf		GPIO,dline		;assume zero bit
	bsf		GPIO,rts		;chip select high
	btfsc	stackselect,0	;if zero - wiper 0 selected
	bsf		GPIO,dline		;if 1 - wiper 1 selected
	bsf		GPIO,clk		;clock in bit
	bcf		GPIO,clk
;send hi byte
	movlw	.9				;load counter for 8 bits
	movwf	bit_count
data_loop
	decfsz	bit_count,f		;decrement bit_count, skip if zero
	goto	continue
	goto 	send_lo					;return from send_data
continue
	bcf		STATUS,C
	rlf		txdataHI			;rotate txdata bits into carry
	bcf		GPIO,dline		;assume zero bit
	btfsc	STATUS,C		;check if carry bit, skip if zero
	bsf		GPIO,dline
	bsf		GPIO, clk		;clock in bit
	bcf		GPIO, clk
	goto	data_loop
send_lo
	movlw	.9				;load counter for 8 bits
	movwf	bit_count
data_loop1
	decfsz	bit_count,f		;decrement bit_count, skip if zero
	goto	continue1
	bcf		GPIO,rts		;chip select low
	return					;return from send_data
continue1
	bcf		STATUS,C
	rlf		txdataLO			;rotate txdata bits into carry
	bcf		GPIO,dline		;assume zero bit
	btfsc	STATUS,C		;check if carry bit, skip if zero
	bsf		GPIO,dline
	bsf		GPIO, clk		;clock in bit
	bcf		GPIO, clk
	goto	data_loop1

	;return from send_data


delay
	movlw	0x80
	movwf	countH
	
outer_loop
	movlw	0xff
	movwf	countL
inner_loop
	decfsz	countL
	goto	inner_loop
	decfsz	countH
	goto	outer_loop
	return						;delay



D_sub
	movfw	ACCaLO
	subwf	ACCbLO,f
	movfw	ACCaHI
	subwf	ACCbHI,f
	return						;D_sub

loadAB
	movlw	0x01
	movwf	ACCaHI
	movlw	0x00				;loads ACCa with 01FF
	movwf	ACCaLO

	movlw	0x01
	movwf	ACCbHI
	movlw	0xe5				;loads ACCb with 7FFF
	movwf	ACCbLO
	return						;loadAB
	

	
	END							; directive 'end of program'


